<?php

/**
 * Get the main image URL for a property
 *
 * @param int $company_id
 * @param int $realestate_id
 * @return string|null
 */
function getMainImage($company_id, $realestate_id)
{
  $image_path = base_path("baza/files/realestate/{$company_id}/{$realestate_id}/web_images");

  if (!is_dir($image_path)) {
    return null;
  }

  $images = scandir($image_path);

  // Filter out . and .. and get only image files
  $image_files = array_filter($images, function ($file) {
    if (in_array($file, ['.', '..'])) {
      return false;
    }
    $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
    return in_array($extension, ['jpg', 'jpeg', 'png', 'gif', 'webp']);
  });

  if (empty($image_files)) {
    return null;
  }

  // Sort and get first image
  sort($image_files);
  $first_image = reset($image_files);

  // Return public URL instead of path
  return route('realestate.image', [
    'company_id' => $company_id,
    'realestate_id' => $realestate_id,
    'filename' => $first_image
  ]);
}

/**
 * Get all image URLs for a property
 *
 * @param int $company_id
 * @param int $realestate_id
 * @return array
 */
function getAllImages($company_id, $realestate_id)
{
  $image_path = base_path("baza/files/realestate/{$company_id}/{$realestate_id}/web_images");

  if (!is_dir($image_path)) {
    return [];
  }

  $images = scandir($image_path);

  // Filter out . and .. and get only image files
  $image_files = array_filter($images, function ($file) {
    if (in_array($file, ['.', '..'])) {
      return false;
    }
    $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
    return in_array($extension, ['jpg', 'jpeg', 'png', 'gif', 'webp']);
  });

  if (empty($image_files)) {
    return [];
  }

  // Sort images
  sort($image_files);

  // Return array of public URLs
  return array_map(function ($filename) use ($company_id, $realestate_id) {
    return route('realestate.image', [
      'company_id' => $company_id,
      'realestate_id' => $realestate_id,
      'filename' => $filename
    ]);
  }, $image_files);
}

/**
 * Convert YouTube URL to embed format
 *
 * @param string $url
 * @return string|null
 */
function getYoutubeEmbedUrl($url)
{
  if (empty($url)) {
    return null;
  }

  // Extract video ID from various YouTube URL formats
  $pattern = '/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/i';

  if (preg_match($pattern, $url, $matches)) {
    $videoId = $matches[1];
    return "https://www.youtube.com/embed/{$videoId}";
  }

  return null;
}
