<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function index()
    {
        return view('contact');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:255',
            'subject' => 'required|string|max:255',
            'message' => 'required|string'
        ]);

        // Prepare email data
        $emailData = [
            'name' => $validated['name'],
            'email' => $validated['email'],
            'phone' => $validated['phone'],
            'subject' => $validated['subject'],
            'contactMessage' => $validated['message'],
        ];

        // Send email to admin
        try {
            Mail::send('emails.contact', $emailData, function ($message) use ($emailData) {
                $message->to('info@imbnekretnine.hr')
                    ->subject('Contact Form: ' . $emailData['subject'])
                    ->replyTo($emailData['email'], $emailData['name']);
            });

            return response()->json([
                'success' => true,
                'message' => __('app.contact_success')
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => __('app.contact_error')
            ], 500);
        }
    }
}
