<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Get locale from session, default to 'hr' (Croatian)
        $locale = session('locale', config('app.locale', 'hr'));

        // Ensure the locale is valid (only 'en' or 'hr')
        if (!in_array($locale, ['en', 'hr'])) {
            $locale = 'hr';
        }

        // Set the application locale
        app()->setLocale($locale);

        return $next($request);
    }
}
