<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\PropertyController;
use App\Http\Controllers\ContactController;
use Illuminate\Support\Facades\Route;



Route::get('/', [HomeController::class, 'index'])->name('index');
Route::get('/locale/{locale}', [HomeController::class, 'changeLocale'])->name('locale');
Route::get('/about', [HomeController::class, 'about'])->name('about');
Route::get('/contact', [ContactController::class, 'index'])->name('contact');
Route::post('/contact', [ContactController::class, 'store'])->name('contact.submit');
Route::get('/terms', [HomeController::class, 'terms'])->name('terms');
Route::get('/privacy-policy', [HomeController::class, 'privacyPolicy'])->name('privacy.policy');
Route::get('/images/realestate/{company_id}/{realestate_id}/{filename}', [HomeController::class, 'serveImage'])->name('realestate.image');


// Real estate view routes (English)
Route::get('/search', [PropertyController::class, 'search'])->name('search.en');
Route::get('/property/{alias?}', [PropertyController::class, 'view'])->name('property.en');

// Real estate view routes (Croatian)
Route::get('/pretraga', [PropertyController::class, 'search'])->name('search.hr');
Route::get('/nekretnina/{alias?}', [PropertyController::class, 'view'])->name('property.hr');

// Property contact form submission
Route::post('/property/contact', [PropertyController::class, 'contactProperty'])->name('property.contact');
