<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', __('app.site_title')); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>" />
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Barlow&family=Barlow+Condensed&family=Gilda+Display&display=swap">
    <link rel="stylesheet" href="<?php echo e(asset('assets')); ?>/css/plugins.css?v=1.0.0" />
    <link rel="stylesheet" href="<?php echo e(asset('assets')); ?>/css/style.css?v=1.0.0" />
</head>

<body>
    <!-- Preloader -->
    <div class="preloader-bg"></div>
    <div id="preloader">
        <div id="preloader-status">
            <div class="preloader-position loader"> <span></span> </div>
        </div>
    </div>
    <!-- Progress scroll totop -->
    <div class="progress-wrap cursor-pointer">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Menu -->
    <div class="imb-wrap">
        <div class="imb-wrap-inner">
            <nav class="imb-menu">
                <ul>
                    <li><a href="<?php echo e(route('index')); ?>"><?php echo e(__('app.nav_home')); ?></a></li>
                    <li><?php echo e(__('app.nav_locations')); ?></li>
                    <ol>
                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a
                                href="<?php echo e(route('search.'.$locale, ['location' => $location->slug])); ?>"><?php echo e($location->name); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ol>
                    <li><?php echo e(__('app.nav_types')); ?></li>
                    <ol>
                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('search.'.$locale, ['type' => $type->slug])); ?>"><?php echo e($type->name); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ol>
                    <li><a href="<?php echo e(route('about')); ?>"><?php echo e(__('app.nav_about')); ?></a></li>
                    <li><a href="<?php echo e(route('contact')); ?>"><?php echo e(__('app.nav_contact')); ?></a></li>
                </ul>
            </nav>
            <div class="imb-menu-footer">
                <div class="reservation">
                    <a href="tel:385913335480">
                        <div class="icon d-flex justify-content-center align-items-center">
                            <i class="flaticon-call"></i>
                        </div>
                        <div class="call"><?php echo e(__('app.call_us')); ?><br><span>+385 91 333 5480</span></div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- Logo & Menu Burger -->
    <header class="imb-header">
        <div class="container-fluid">
            <div class="row align-items-center">
                <!-- Logo -->
                <div class="col-6 col-md-6 imb-logo-wrap">
                    <a href="<?php echo e(url('/')); ?>" class="imb-logo"><img src="<?php echo e(asset('assets')); ?>/images/logo.png" alt=""></a>
                </div>
                <!-- Menu Burger -->
                <div class="col-6 col-md-6 d-flex justify-content-end align-items-center gap-4">
                    <div class="header-language">
                        <select onchange="window.location.href = this.value;">
                            <option value="<?php echo e(route('locale', 'en')); ?>" <?php echo e(app()->getLocale() == 'en' ? 'selected' : ''); ?>>EN</option>
                            <option value="<?php echo e(route('locale', 'hr')); ?>" <?php echo e(app()->getLocale() == 'hr' ? 'selected' : ''); ?>>HR</option>
                        </select>
                    </div>
                    <div class="text-right imb-wrap-burger-wrap w-auto">
                        <a href="#" class="imb-nav-toggle imb-js-imb-nav-toggle"><i></i></a>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <?php echo $__env->yieldContent('content'); ?>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-top">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="footer-column footer-about text-center">
                            <h3 class="footer-title">
                                <img src="<?php echo e(asset('assets')); ?>/images/logo.png" alt="IMB" style="width: 180px;">
                            </h3>
                            <p class="footer-about-text">
                                <?php echo e(__('app.footer_about')); ?>

                            </p>
                            <i class="footer-about-text mt-2"><?php echo e(__('app.footer_verse')); ?></i>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="container">
                <div class="row">
                    <div class="col-md-9">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="footer-column footer-explore clearfix">
                                    <h3 class="footer-title"><?php echo e(__('app.nav_locations')); ?></h3>
                                    <ul class="footer-explore-list list-unstyled">
                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo e(route('search.'.$locale, ['location' => $location->slug])); ?>"><?php echo e($location->name); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="footer-column footer-explore clearfix">
                                    <h3 class="footer-title"><?php echo e(__('app.nav_types')); ?></h3>
                                    <ul class="footer-explore-list list-unstyled">
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo e(route('search.'.$locale, ['type' => $type->slug])); ?>"><?php echo e($type->name); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="footer-column footer-explore clearfix">
                                    <h3 class="footer-title"><?php echo e(__('app.nav_important_links')); ?></h3>
                                    <ul class="footer-explore-list list-unstyled">
                                        <li><a href="<?php echo e(route('index')); ?>"><?php echo e(__('app.nav_home')); ?></a></li>
                                        <li><a href="<?php echo e(route('about')); ?>"><?php echo e(__('app.nav_about')); ?></a></li>
                                        <li><a href="<?php echo e(route('contact')); ?>"><?php echo e(__('app.nav_contact')); ?></a></li>


                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="footer-column footer-contact">
                            <h3 class="footer-title"><?php echo e(__('app.nav_contact')); ?></h3>
                            <p class="footer-contact-text">Vukovarska 30 20000 Dubrovnik, Croatia</p>
                            <div class="footer-contact-info">
                                <p class="footer-contact-phone"><span class="flaticon-call"></span> +385 (0)20 451 800
                                </p>
                                <span class="footer-contact-mail">info@imbnekretnine.hr</span>
                                <span class="footer-contact-mail">nada@imbnekretnine.hr</span>
                            </div>
                            <div class="footer-about-social-list">
                                <a href="#"><i class="ti-instagram"></i></a>
                                <a href="#"><i class="fa-brands fa-x-twitter"></i></a>
                                <a href="#"><i class="ti-youtube"></i></a>
                                <a href="#"><i class="ti-facebook"></i></a>
                                <a href="#"><i class="fa-brands fa-tiktok"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="footer-bottom-inner">
                            <p class="footer-bottom-copy-right text-uppercase">© <?php echo e(__('app.copyright')); ?> <?php echo e(date('Y')); ?>

                                by <a href="<?php echo e(url('/')); ?>">IMB Real Estate LTD.</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- jQuery -->
    <script src="<?php echo e(asset('assets')); ?>/js/jquery-3.7.1.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/jquery-migrate-3.5.0.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/modernizr-2.6.2.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/imagesloaded.pkgd.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/jquery.isotope.v3.0.2.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/pace.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/popper.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/scrollIt.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/jquery.waypoints.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/owl.carousel.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/jquery.stellar.min.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/jquery.magnific-popup.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/YouTubePopUp.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/select2.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/datepicker.js"></script>
    <script src="<?php echo e(asset('assets')); ?>/js/smooth-scroll.min.js"></script>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    <script src="<?php echo e(asset('assets')); ?>/js/custom.js"></script>
</body><?php /**PATH Z:\Inetpub\www\imbnekretnine\resources\views/app.blade.php ENDPATH**/ ?>