<?php $__env->startSection('title', __('app.site_title')); ?>
<?php $__env->startSection('content'); ?>
<!-- Header Video -->
<!-- Booking Search -->
<div class="search-wrapper">
  <div class="search-wrapper-inner">
      <div class="container">
        <div class="row">
          <div class="col-md-10 offset-md-1 text-center"> 
              <h1><?php echo e(__('home.hero_title')); ?></h1>
              <h4><?php echo e(__('home.hero_subtitle')); ?></h4>
          </div>
      </div>
          <div class="booking-inner clearfix">
              <form action="<?php echo e(route('search.'.$locale)); ?>" method="GET" class="form1 clearfix">
                  <div class="col2 c3">
                      <div class="input1_wrapper">
                          <div class="input1_inner">
                              <input type="text" class="form-control input" placeholder="<?php echo e(__('home.search_placeholder')); ?>" name="query" value="<?php echo e($search_query); ?>">
                          </div>
                      </div>
                  </div>
                  <div class="col2 c3">
                      <div class="select1_wrapper">
                          <label><?php echo e(__('home.search_location')); ?></label>
                          <div class="select1_inner">
                              <select class="select2 select" style="width: 100%" name="location" value="<?php echo e($location); ?>">
                                  <option value=""><?php echo e(__('home.search_location_select')); ?></option>
                                  <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <option value="<?php echo e($item->slug); ?>" <?php echo e($item->slug == $location ? 'selected' : ''); ?>><?php echo e($item->name); ?></option>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="col2">
                      <div class="select1_wrapper">
                          <label><?php echo e(__('home.search_type')); ?></label>
                          <div class="select1_inner">
                              <select class="select2 select" style="width: 100%" name="type" value="<?php echo e($type); ?>">
                                  <option value=""><?php echo e(__('home.search_type_select')); ?></option>
                                  <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <option value="<?php echo e($item->slug); ?>" <?php echo e($item->slug == $type ? 'selected' : ''); ?>><?php echo e($item->name); ?></option>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="col2">
                      <button type="submit" class="btn-form1-submit"><?php echo e(__('home.search_button')); ?></button>
                  </div>
              </form>
          </div>
      </div>
      </div>
</div>

<!-- Rooms -->
<section class="rooms1 py-5 bg-darkgray" data-scroll-index="1">
  <div class="container-fluid">
      
      <div class="row">
          <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <div class="col-md-<?php echo e(($key % 5) ? '3' : '6'); ?>">
            <?php echo $__env->make('property.card', ['property' => $property], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <div class="col-md-12 text-center">
              <span class="text-white text-center"><?php echo e(__('home.no_properties_found')); ?></span>
          </div>
          <?php endif; ?>
         
       

          <?php if(count($properties) > 0): ?>
          <div class="col-md-12">
              <div class="d-flex justify-content-center mt-4 mb-5">
                  <?php echo e($properties->links()); ?>

              </div>
          </div>
          <?php endif; ?>
      </div>
  </div>
</section>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH Z:\Inetpub\www\imbnekretnine\resources\views/search.blade.php ENDPATH**/ ?>