<?php $__env->startSection('title', __('app.site_title')); ?>
<?php $__env->startSection('content'); ?>
<!-- Header Video -->
<header class="header">
    <div class="video-fullscreen-wrap">
        <!-- The opacity on the image is made with "data-overlay-dark="number". You can change it using the numbers 0-9. -->
        <div class="video-fullscreen-video" data-overlay-dark="6">
            <video playsinline="" autoplay="" loop="" muted="">
                <source src="<?php echo e(asset('assets/video/hero')); ?>.mp4?v=1.0.0" type="video/mp4" autoplay="" loop="" muted="">
                <source src="<?php echo e(asset('assets/video/hero')); ?>.webm?v=1.0.0" type="video/webm" autoplay="" loop="" muted="">
            </video>
        </div>
        <div class="v-middle caption overlay">
                <div class="container">
                    <div class="row">
                        <div class="col-md-10 offset-md-1"> 
                            <h1><?php echo e(__('home.hero_title')); ?></h1>
                            <h4><?php echo e(__('home.hero_subtitle')); ?></h4>
                            
                        </div>
                    </div>
                </div>
            </div>
    </div>
</header>
<!-- Booking Search -->
<div class="booking-wrapper">
        <div class="container">
            <div class="booking-inner clearfix">
                <form action="<?php echo e(route('search.'.$locale)); ?>" method="GET" class="form1 clearfix">
                    <div class="col2 c3">
                        <div class="input1_wrapper">
                            <div class="input1_inner">
                                <input type="text" class="form-control input" placeholder="<?php echo e(__('home.search_placeholder')); ?>" name="query">
                            </div>
                        </div>
                    </div>
                    <div class="col2 c3">
                        <div class="select1_wrapper">
                            <label><?php echo e(__('home.search_location')); ?></label>
                            <div class="select1_inner w-100">
                                <select class="select2 select" style="width: 100%" name="location">
                                    <option value=""><?php echo e(__('home.search_location_select')); ?></option>
                                    <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($location->slug); ?>"><?php echo e($location->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col2">
                        <div class="select1_wrapper">
                            <label><?php echo e(__('home.search_type')); ?></label>
                            <div class="select1_inner">
                                <select class="select2 select" style="width: 100%" name="type">
                                    <option value=""><?php echo e(__('home.search_type_select')); ?></option>
                                    <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type->slug); ?>"><?php echo e($type->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col2">
                        <button type="submit" class="btn-form1-submit"><?php echo e(__('home.search_button')); ?></button>
                    </div>
                </form>
            </div>
        </div>
</div>

<!-- Rooms -->
<section class="rooms1 bg-darkblack py-5" data-scroll-index="1">
    <div class="container-fluid">
        
        <div class="row mb-3">
            <div class="col-md-12 text-center">
                <div class="section-subtitle text-white"><?php echo e(__('home.section_subtitle')); ?></div>
                <div class="section-title"><?php echo e(__('home.section_title')); ?></div>
            </div>
        </div>


        
        <div class="row">
            <!--
            <?php $__currentLoopData = $featured_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-<?php echo e($key > 2 ? '6' : '4'); ?>">
                <?php echo $__env->make('property.card', ['property' => $property], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            -->
         

            <div class="col-md-12">
                <div class="text-center pt-3">
                    <div class="butn-dark"> <a href="<?php echo e(route('search.'.$locale,['location' => 'dubrovnik','type' => $locale == 'en' ? 'villas' : 'ville'])); ?>"><span><?php echo e(__('home.see_all_villas')); ?></span></a> </div>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- Why Choose us -->
<section class="why-choose-us">
    <div class="background bg-img bg-fixed pb-0" data-background="<?php echo e(asset('assets')); ?>/images/dubrovnik1-dark.jpg">
        <div class="container-fluid section-padding px-5" style="margin-bottom: -50px;">
            <div class="row">
                <div class="col-md-6 mb-30 animate-box" data-animate-effect="fadeInUp">
                    <div class="section-title font-weight-bold"><?php echo e(__('home.luxury_experience')); ?></div>
                    <p class="font-weight-bold"><?php echo e(__('home.best_result')); ?></p>
                  
                    
                    <h2>1. <?php echo e(__('home.professionalism')); ?></h2> 
                    <h2>2. <?php echo e(__('home.pedantry')); ?></h2>
                    <h2>3. <?php echo e(__('home.sacrifice')); ?></h2>
                </div>
                <div class="col-md-6 mb-30 animate-box d-flex align-items-center justify-content-center" data-animate-effect="fadeInUp">
                    <img src="<?php echo e(asset('assets')); ?>/images/logo.png" alt="" class="img-fluid" style="width: 450px">
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH Z:\Inetpub\www\imbnekretnine\resources\views/index.blade.php ENDPATH**/ ?>